# CAVERN QUEST 
# PORTED FROM BALLY BASIC
# ORIGINAL BY BRUCE JAEGER 
# CREATIVE COMPUTING JULY 1983
# PAGES 222-225
# PORT BY GREG BENNETT, 2022

# NOTE: BC, NT, FC ARE BALLY SPECIFIC VARIABLES AND ARE UNUSED ON ZX-81
#       LINE NUMBER LABELS CORRESPOND TO THE BALLY BASIC CODE LINE NUMBERS

# TO BUILD:
#       USE zmakebas.exe TO CONVERT CODE TO ZX-81 BASIC
#       https://derekbolli.wordpress.com/2012/11/16/create-zx-spectrum-basic-program-tap-file-from-text-source-file-in-bbedit-using-zmakebas/
#       https://www.dropbox.com/s/n7k40ezuj0j3m99/zmakebas-1.5.2.zip?dl=1
#       RUN ZMAKEBAS THE FOLLOWING COMMAND LINE OPTIONS:
#       Zmakebas -p -l -s 10 -a 10 -i 10 -o cavern.p CavernQuestZX.bas

@START:

	GOSUB @TITLESCREEN
	DIM Q(312)

#	REM LINE 1
#	LET BC=48
#	LET FC=125
#	CLS
	LET E=10
	LET Z=0
	LET B=300
	LET T=B
	LET C=B/2
	LET O=7
	LET MV=0
# ZX-81 ZEROES OUT Q() ARRAY BY DEFAULT 
#	FOR A=1 TO B+11
#	LET Q(A)=Z
#	NEXT A

#	REM LINE 2
	LET A=E
	LET Q(A)=1
#	CLS

	RAND
	PRINT AT 12,O+1;" PERCENT COMPLETE"
	
@LINE03:
#	REM LINE 3
	LET D=(INT (RND *7)) + 1
	LET PT=100-INT(T/3)
	IF PT>9 AND PT<100 THEN LET O=6
	IF PT>99 THEN LET O=5
	PRINT AT 12,O;PT
	LET T=T-1
	IF T=0 THEN GOTO @LINE24

#	REM LINES 4-9
	IF D=2 THEN LET D=-1
	IF D=3 THEN LET D=-E
	IF D=4 THEN LET D=E
	IF D=5 THEN LET D=-C
	IF D=6 THEN LET D=C
	IF D=7 THEN GOTO @LINE18

@LINE10:
#	REM LINE 10
	LET H=A+D
	IF H<1 THEN GOTO @LINE03

#	REM LINE 11
	IF H>B THEN GOTO @LINE03

#	REM LINE 12
	LET K=Q(H)
	IF K=3 THEN GOTO @LINE03

#	REM LINE 13
	IF K=4 THEN GOTO @LINE03

#	REM LINE 14
	IF K>B THEN GOTO @LINE03

#	REM LINE 15
	LET Q(H)=1
	IF D<>-C THEN GOTO @LINE16
#	REM D=-C
	LET Q(A)=3
	LET Q(H)=4

@LINE16:
#	REM LINE 16
	IF D<>C THEN GOTO @LINE17
#	REM D=C
	LET Q(H)=3
	LET Q(A)=4

@LINE17:
#	REM LINE 17
	LET A=H
	GOTO @LINE03

@LINE18:
#	REM LINE 18
	IF (INT(RND*3))+1 <> 2 THEN GOTO @LINE10

#	REM LINE 19
	IF Q(A)<>1 THEN GOTO @LINE03

#	REM LINE 20
	LET Z=Z+1
	LET K=0
	IF Z>E THEN GOTO @LINE03

@LINE21:
#	REM LINE 21
	LET Y=(INT(RND*E))+1
	LET K=K+1
	IF K=40 THEN GOTO @LINE03

#	REM LINE 22
	IF Q(Y+B)<>0 THEN GOTO @LINE21

#	REM LINE 23
	LET Q(A)=Y+B
	LET Q(Y+B)=1
	GOTO @LINE03

@LINE24:
#	REM LINE 24
	LET Q(A)=B+11
	CLS
	LET A=E
	LET G=0

@LINE25:
#	REM LINE 25
	CLS
	IF A<>E THEN GOTO @LINE27

#	REM LINE 26
	PRINT "entrance RETURN WITH TREASURE"
	IF G<>1 THEN GOTO @LINE27:
	REM G=1
#	LET BC=102
#	LET FC=16
	PRINT AT 2,6;"\::congratulations\::"
	PRINT AT 3,3;"YOU MADE IT IN ";MV;" MOVES"
#	LET NT=2
	STOP

@LINE27:
#	REM LINE 27
	PRINT "PASSAGES LEAD:      ";MV;" MOVES"
	IF A>E THEN IF Q(A-E)<>0 THEN PRINT "  nORTH"

#	REM LINES 28-32
	IF A<(B-E) THEN IF Q(A+E)<>0 THEN PRINT "  sOUTH"
	IF Q(A-1)<>0 THEN PRINT "  wEST"
	IF A<B AND Q(A+1)<>0 THEN PRINT "  eAST"
	IF Q(A)=4 THEN PRINT "  cLIMB UP"
	IF Q(A)=3 THEN PRINT "  cLIMB DOWN"

#	REM LINE 33
	PRINT " "
	IF Q(A)<B THEN GOTO @LINE46:

#	REM LINE 34
	PRINT "YOU SEE:"
	LET X=Q(A)-B

#	REM LINES 35-44
	IF X=1 THEN PRINT "  A BOOT"
	IF X=2 THEN PRINT "  A SKELETON"
	IF X=3 THEN PRINT "  A SHOVEL"
	IF X=4 THEN PRINT "  MILDEWED SADDLEBAGS"
	IF X=5 THEN PRINT "  A RUSTY PISTOL"
	IF X=6 THEN PRINT "  A BROKEN LANTERN"
	IF X=7 THEN PRINT "  C. SINCLAIR WAS HERE"
	IF X=8 THEN PRINT "  YUK.. BATS.."
	IF X=9 THEN PRINT "  A BUSTED LADDER"
	IF X=10 THEN PRINT "  AN EMPTY TRUNK"

#	REM LINE 45
	IF X<>11 THEN GOTO @LINE46:
#	REM X=11
	PRINT "*** TREASURE ***"
	LET G=1
	LET Q(A)=1

#	TR(1) IS CONTROLLER 1 TRIGGER ON BALLY (0=UNPRESSED  1=PRESSED)
#	JX(1) IS CONTROLLER 1 X VALUE (-1=LEFT 0=NONE 1=RIGHT)
#	JY(1) IS CONTROLLER 1 Y VALUE (-1=DOWN 0=NONE 1=UP)
#	REM LINES 46-48 MOVE LOGIC 
#	REM "N/7"=FORWARD/NORTH "S/6"=BACK/SOUTH "W/5"=LEFT/WEST "E/8"=RIGHT/EAST "C"=CLIMB UP/DOWN
@LINE46:
	LET V=0
	LET J=0
	LET R=0
	LET I$=INKEY$
	IF I$="" THEN GOTO @LINE46
	IF I$<>"W" AND I$<>"5" THEN GOTO @NOTWEST
#	REM I$ = "W" (JX(1)=-1) (LEFT/WEST)
	LET J=-1
	GOTO @LINE50
@NOTWEST:
	IF I$<>"E" AND I$<>"8" THEN GOTO @NOTEAST:
#	REM I$ = "E" (JX(1)=1) (RIGHT/EAST)
	LET J=1
	GOTO @LINE50
@NOTEAST:
	IF I$<>"N" AND I$<>"7" THEN GOTO @NOTNORTH
#	REM I$ = "N" (JY(1)=1) (FORWARD/NORTH)
	LET V=1
	GOTO @LINE50
@NOTNORTH:
	IF I$<>"S" AND I$<> "6" THEN GOTO @NOTSOUTH
#	REM I$ = "S" (JY(1)=-1) (BACK/SOUTH)
	LET V=-1
	GOTO @LINE50
@NOTSOUTH:
	IF I$<>"C" THEN GOTO @LINE46
#	REM I$="C" (TR(1)=1) (TRIGGER CLIMB UP/DOWN)
	LET R=1
	GOTO @LINE50

#LINE 49
#	REM LINE 49
	GOTO @LINE46
	
@LINE50:
#	REM LINES 50-53
	LET MV=MV+1
	IF V=1 THEN LET L=A-E
	IF V=-1 THEN LET L=A+E
	IF J=1 THEN LET L=A+1
	IF J=-1 THEN LET L=A-1

#LINE 54
#	REM LINE 54
	IF Q(A)<>3 OR R=0 THEN GOTO @LINE55
#	REM Q(A)=3 AND R<>0
	LET L=A-C
	GOTO @LINE56

@LINE55:
#	REM LINE 55
	IF Q(A)=4 AND R<>0 THEN LET L=A+C

@LINE56:
#	REM LINES 56-58
	IF L<1 THEN GOTO @LINE60
	IF L>B THEN GOTO @LINE60
	IF Q(L)=0 THEN GOTO @LINE60

#	REM LINE 59
	LET A=L
	GOTO @LINE25

@LINE60:
#	REM LINE 60
	LET MV=MV-1
	PRINT AT 9,0;"***SOLID ROCK***"
	GOTO @LINE46


@TITLESCREEN:
	CLS
	GOSUB @POPUPWINDOW
	PRINT AT 7,9;"\::cavern\::quest\::"
	PRINT AT 8,3;"ORIGINAL BY BRUCE JAEGER"
	PRINT AT 9,3;"CREATIVE COMPUTING 07/83"
	PRINT AT 11,9;"INITIALIZING "
	RETURN

@POPUPWINDOW:
	PRINT AT 6,2;"\:'\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\''\': "
	FOR T=1 TO 6
	PRINT AT 6+T,2;"\:                          \ :  "
	NEXT T
	PRINT AT 13,2;"\:.\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\..\.: "
	RETURN